

class String


  # Renvoie le dernier caractre d'une string
  def dernier
    return self.last
  end

  def last(nb=1)
    return self[self.size-nb...self.size]
  end

  def first
    return self[0..0]
  end

  def to(nb=0)
    return self[0..nb]
  end

  def from(nb=0)
    return self[nb...self.size]
  end

  def delete_reg(reg)
    return self.gsub(reg, '')
  end

  def delete_reg!(reg)
    return self.gsub!(reg, '')
  end


  # Renvoie le premier caractre d'une string
  def premier
    return self.first
  end

  # Compare la string  une autre, sur la longueur de cette autre string
  def egal_court(str)
    return egal_short(str)
  end

  # Compare the first part of two strings
  def egal_short(str)
    if self.size > str.size
      return self[0...str.size] == str
    else
      return str[0...self.size] == self
    end
  end



  def just(nb=0)
    return " "*nb+self
  end


  def just_lines(nb=0)
    lines = self.split("\n")
    lines.collect!{|line|
      line = " "*nb+line
    }
    lines << ""
    return lines.join("\n")

  end


  def basename
    return File.basename(self)
  end

  def real_basename
    dirname = self.dirname
    real = from(dirname.size)
    real.shift! if real.first == "/"
    return real
  end


  def dirname
    return File.dirname(self)
  end

  def extname
    return File.extname(self)
  end

  def join(*strings)
    return File.join(self, *strings)
  end
  

  def pop!
    return self if self.size == 0
    str = self[0...self.size-1]
    last = self.last
    self.replace(str)
    return last
  end

  def shift!
    return self if self.size == 0
    str = self[1...self.size]
    first = self.first
    self.replace(str)
    return first
  end

  def pop
    str = self.clone
    return str.pop!
  end


  def shift
    str = self.clone
    return str.shift!
  end


  # Compare la string  une srie de regexp et renvoie vrai si elle
  # correspond  au moins une d'entre elles
  def regexp_egal(*regs)
    for reg in regs
      return true if reg.match(self) != nil
    end
    return false
  end


  def add_max(word, max)

    if self.size+word.size > max
      return self+word
    end

    return self+" "*(max-self.size-word.size)+word

  end

  def subreg(reg, str)
    # On dcompose la string :
    #  $1zz$2 => $1+zz+$2
    #  zz$1$2 => zz+$1+$2

    str2 = str.gsub(/\$(\d)/){'"+'+$&+'+"'}
    if str2.to(1) == '"+'
      str2 = str2.from(2)
    else
      str2 = '"' + str2
    end
    if str2.last(2) == '+"'
      str2.pop!
      str2.pop!
    else
      str2 = str2+'"'
    end

    str2.gsub!(/\+""\+/, '+')

 

    t = self.gsub(reg){eval str2}

  end

  def get_reg(reg)
    m = reg.match(self)
    return nil if m == nil
    return m[1]
  end
  

  def valid_file_name
    return self.dirname.join(self.basename.gsub(/[:\*"?<>|\/\\]/, ''))

  end
  #subreg //, "$1$2zz"
  #subreg //, "zz$1$2"

  
  def split_byte
    arr = []
    self.each_byte{|x|
      arr << x
    }
    return arr
  end


  def convert_utf8
    #phrase = phrase.gsub("\351", "\303\251")
    #phrase = phrase.gsub("\352", "\303\252")
    # la mthode :
    # phrase[i..i] vaut \351
    # \351 devient 233 (valeur du bit)
    # 233 devient 169 (on fait 233-64)
    # 169 devient \251 (on transforme d'aprs la valeur du bit)

    num = self.unpack("C*")

    return "" if num.size == 0

    new_phrase = ""
    old_pos = 0
    for i in 0...num.size
      if num[i] >= 192
        #new_phrase += phrase[old_pos...i]+"\303\\#{num[i]-64}"
        new_phrase += self[old_pos...i]+"\303"+[(self[i..i].unpack('C'))[0]-64].pack('C')
        old_pos = i+1
        next
      end
    end
    new_phrase += self[old_pos..i]

    return new_phrase

  end



  def convert_ansi

    # la mthode(phrase[i..i] vaut \303) :
    # \303\251 devient 169 (valeur du deuxime bit)
    # 169 devient 233 (on fait 169+64)
    # 233 devient \351 (on transforme d'aprs la valeur du bit)
    return "" if self == ""

    num = self.unpack("C*")
    #p num

    new_phrase = ""
    old_pos = 0
    for i in 0...num.size
      if num[i] == 195
        #new_phrase += phrase[old_pos...i]+"\303\\#{num[i]-64}"
        new_phrase += self[old_pos...i]+[(self[i+1..i+1].unpack('C'))[0]+64].pack('C')
        old_pos = i+2
      else
        if num[i] == 194
          #puts "194 !"
          new_phrase += self[old_pos...i]+[(self[i+1..i+1].unpack('C'))[0]].pack('C')
          old_pos = i+2
        end
      end
    end
    new_phrase += self[old_pos..i]

    return new_phrase

  end


  def to_bit
    return self.force_encoding("ASCII-8BIT")
  end

  def to_hex
    txt = ""
    self.each_byte{|x|
      txt << (" %02x" % x).upcase
    }
    return txt

  end

  def to_byte
    txt = ""
    self.each_byte{|x|
      txt << ("\\%03i" % x)
    }
    return txt

  end

  def b
    return to_byte
  end


  # From jatkins on Snipplr.com
  # http://snipplr.com/view.php?codeview&id=36365
  def find_nth_occurrence(substring, n)
    position = -1
    if n > 0 && self.include?(substring) # is n positive, and var includes substring
      i = 0
      while i < n do
        position = self.index(substring, position+substring.length) if position != nil
        i += 1
      end
    end
    return position != nil && position != -1 ? position + 1 : -1; # return the index of the nth occurrence of substring if it exists, otherwise -1
  end


  
  # return true is self is bigger than another version
  def bigger_than?(another)
    before = self.split(".")
    after = another.split(".")

    for i in 0...before.size
      if before[i].to_i > after[i].to_i
        return true
      elsif before[i].to_i < after[i].to_i
        return false
      end
    end

    # We check if number versions have the same length
    if before.size > after.size
      # All numbers from before[0] to before[before.size] are equals to numbers
      # from after, but before have more numbers
      #  before : 3.9.2.1
      #  after  : 3.9.2
      return true
    elsif before.size < after.size
      return false
    end

    # Before and after are equals
    return false

  end
  
end
